package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopRemoteAccessSessionResponse(
    remoteAccessSession: Optional[
      zio.aws.devicefarm.model.RemoteAccessSession
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionResponse = {
    import StopRemoteAccessSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionResponse
      .builder()
      .optionallyWith(remoteAccessSession.map(value => value.buildAwsValue()))(
        _.remoteAccessSession
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.StopRemoteAccessSessionResponse.ReadOnly =
    zio.aws.devicefarm.model.StopRemoteAccessSessionResponse
      .wrap(buildAwsValue())
}
object StopRemoteAccessSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.StopRemoteAccessSessionResponse =
      zio.aws.devicefarm.model.StopRemoteAccessSessionResponse(
        remoteAccessSession.map(value => value.asEditable)
      )
    def remoteAccessSession
        : Optional[zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly]
    def getRemoteAccessSession: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly
    ] = AwsError.unwrapOptionField("remoteAccessSession", remoteAccessSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionResponse
  ) extends zio.aws.devicefarm.model.StopRemoteAccessSessionResponse.ReadOnly {
    override val remoteAccessSession
        : Optional[zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAccessSession())
        .map(value => zio.aws.devicefarm.model.RemoteAccessSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionResponse
  ): zio.aws.devicefarm.model.StopRemoteAccessSessionResponse.ReadOnly =
    new Wrapper(impl)
}
