package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopRunResponse(
    run: Optional[zio.aws.devicefarm.model.Run] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.StopRunResponse = {
    import StopRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.StopRunResponse
      .builder()
      .optionallyWith(run.map(value => value.buildAwsValue()))(_.run)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.StopRunResponse.ReadOnly =
    zio.aws.devicefarm.model.StopRunResponse.wrap(buildAwsValue())
}
object StopRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.StopRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.StopRunResponse =
      zio.aws.devicefarm.model
        .StopRunResponse(run.map(value => value.asEditable))
    def run: Optional[zio.aws.devicefarm.model.Run.ReadOnly]
    def getRun: ZIO[Any, AwsError, zio.aws.devicefarm.model.Run.ReadOnly] =
      AwsError.unwrapOptionField("run", run)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.StopRunResponse
  ) extends zio.aws.devicefarm.model.StopRunResponse.ReadOnly {
    override val run: Optional[zio.aws.devicefarm.model.Run.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.run())
        .map(value => zio.aws.devicefarm.model.Run.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.StopRunResponse
  ): zio.aws.devicefarm.model.StopRunResponse.ReadOnly = new Wrapper(impl)
}
