package zio.aws.devicefarm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  Message,
  DateTime,
  Name,
  AmazonResourceName
}
import scala.jdk.CollectionConverters.*
final case class Suite(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    `type`: Optional[zio.aws.devicefarm.model.TestType] = Optional.Absent,
    created: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.devicefarm.model.ExecutionStatus] =
      Optional.Absent,
    result: Optional[zio.aws.devicefarm.model.ExecutionResult] =
      Optional.Absent,
    started: Optional[DateTime] = Optional.Absent,
    stopped: Optional[DateTime] = Optional.Absent,
    counters: Optional[zio.aws.devicefarm.model.Counters] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    deviceMinutes: Optional[zio.aws.devicefarm.model.DeviceMinutes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Suite = {
    import Suite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Suite
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(started.map(value => DateTime.unwrap(value): Instant))(
        _.started
      )
      .optionallyWith(stopped.map(value => DateTime.unwrap(value): Instant))(
        _.stopped
      )
      .optionallyWith(counters.map(value => value.buildAwsValue()))(_.counters)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(deviceMinutes.map(value => value.buildAwsValue()))(
        _.deviceMinutes
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Suite.ReadOnly =
    zio.aws.devicefarm.model.Suite.wrap(buildAwsValue())
}
object Suite {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Suite] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Suite =
      zio.aws.devicefarm.model.Suite(
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        created.map(value => value),
        status.map(value => value),
        result.map(value => value),
        started.map(value => value),
        stopped.map(value => value),
        counters.map(value => value.asEditable),
        message.map(value => value),
        deviceMinutes.map(value => value.asEditable)
      )
    def arn: Optional[AmazonResourceName]
    def name: Optional[Name]
    def `type`: Optional[zio.aws.devicefarm.model.TestType]
    def created: Optional[DateTime]
    def status: Optional[zio.aws.devicefarm.model.ExecutionStatus]
    def result: Optional[zio.aws.devicefarm.model.ExecutionResult]
    def started: Optional[DateTime]
    def stopped: Optional[DateTime]
    def counters: Optional[zio.aws.devicefarm.model.Counters.ReadOnly]
    def message: Optional[Message]
    def deviceMinutes: Optional[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.TestType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResult
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResult] =
      AwsError.unwrapOptionField("result", result)
    def getStarted: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("started", started)
    def getStopped: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stopped", stopped)
    def getCounters
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Counters.ReadOnly] =
      AwsError.unwrapOptionField("counters", counters)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getDeviceMinutes
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      AwsError.unwrapOptionField("deviceMinutes", deviceMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Suite
  ) extends zio.aws.devicefarm.model.Suite.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val `type`: Optional[zio.aws.devicefarm.model.TestType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.devicefarm.model.TestType.wrap(value))
    override val created: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.devicefarm.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devicefarm.model.ExecutionStatus.wrap(value))
    override val result: Optional[zio.aws.devicefarm.model.ExecutionResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value => zio.aws.devicefarm.model.ExecutionResult.wrap(value))
    override val started: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.started())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val stopped: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.stopped())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val counters
        : Optional[zio.aws.devicefarm.model.Counters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.counters())
        .map(value => zio.aws.devicefarm.model.Counters.wrap(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val deviceMinutes
        : Optional[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceMinutes())
        .map(value => zio.aws.devicefarm.model.DeviceMinutes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Suite
  ): zio.aws.devicefarm.model.Suite.ReadOnly = new Wrapper(impl)
}
