package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.DeviceFarmArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceARN: DeviceFarmArn,
    tags: Iterable[zio.aws.devicefarm.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.TagResourceRequest
      .builder()
      .resourceARN(DeviceFarmArn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.TagResourceRequest.ReadOnly =
    zio.aws.devicefarm.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.TagResourceRequest =
      zio.aws.devicefarm.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: DeviceFarmArn
    def tags: List[zio.aws.devicefarm.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.devicefarm.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.TagResourceRequest
  ) extends zio.aws.devicefarm.model.TagResourceRequest.ReadOnly {
    override val resourceARN: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.resourceARN())
    override val tags: List[zio.aws.devicefarm.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.devicefarm.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.TagResourceRequest
  ): zio.aws.devicefarm.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
