package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestGridVpcConfig(
    securityGroupIds: Iterable[NonEmptyString],
    subnetIds: Iterable[NonEmptyString],
    vpcId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.TestGridVpcConfig = {
    import TestGridVpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.TestGridVpcConfig
      .builder()
      .securityGroupIds(securityGroupIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnetIds(subnetIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .vpcId(NonEmptyString.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly =
    zio.aws.devicefarm.model.TestGridVpcConfig.wrap(buildAwsValue())
}
object TestGridVpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.TestGridVpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.TestGridVpcConfig =
      zio.aws.devicefarm.model
        .TestGridVpcConfig(securityGroupIds, subnetIds, vpcId)
    def securityGroupIds: List[NonEmptyString]
    def subnetIds: List[NonEmptyString]
    def vpcId: NonEmptyString
    def getSecurityGroupIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(subnetIds)
    def getVpcId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridVpcConfig
  ) extends zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly {
    override val securityGroupIds: List[NonEmptyString] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.devicefarm.model.primitives.NonEmptyString(item)
      }
      .toList
    override val subnetIds: List[NonEmptyString] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.devicefarm.model.primitives.NonEmptyString(item)
      }
      .toList
    override val vpcId: NonEmptyString =
      zio.aws.devicefarm.model.primitives.NonEmptyString(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridVpcConfig
  ): zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly = new Wrapper(impl)
}
