package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  ResourceDescription,
  ResourceName,
  DeviceFarmArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateTestGridProjectRequest(
    projectArn: DeviceFarmArn,
    name: Optional[ResourceName] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    vpcConfig: Optional[zio.aws.devicefarm.model.TestGridVpcConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest = {
    import UpdateTestGridProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest
      .builder()
      .projectArn(DeviceFarmArn.unwrap(projectArn): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateTestGridProjectRequest.ReadOnly =
    zio.aws.devicefarm.model.UpdateTestGridProjectRequest.wrap(buildAwsValue())
}
object UpdateTestGridProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateTestGridProjectRequest =
      zio.aws.devicefarm.model.UpdateTestGridProjectRequest(
        projectArn,
        name.map(value => value),
        description.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def projectArn: DeviceFarmArn
    def name: Optional[ResourceName]
    def description: Optional[ResourceDescription]
    def vpcConfig: Optional[zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly]
    def getProjectArn: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(projectArn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest
  ) extends zio.aws.devicefarm.model.UpdateTestGridProjectRequest.ReadOnly {
    override val projectArn: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.projectArn())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.ResourceName(value))
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.devicefarm.model.primitives.ResourceDescription(value)
        )
    override val vpcConfig
        : Optional[zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.devicefarm.model.TestGridVpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest
  ): zio.aws.devicefarm.model.UpdateTestGridProjectRequest.ReadOnly =
    new Wrapper(impl)
}
