package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  ServiceDnsName,
  VPCEConfigurationName,
  AmazonResourceName,
  VPCEServiceName,
  VPCEConfigurationDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVpceConfigurationRequest(
    arn: AmazonResourceName,
    vpceConfigurationName: Optional[VPCEConfigurationName] = Optional.Absent,
    vpceServiceName: Optional[VPCEServiceName] = Optional.Absent,
    serviceDnsName: Optional[ServiceDnsName] = Optional.Absent,
    vpceConfigurationDescription: Optional[VPCEConfigurationDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest = {
    import UpdateVpceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(
        vpceConfigurationName.map(value =>
          VPCEConfigurationName.unwrap(value): java.lang.String
        )
      )(_.vpceConfigurationName)
      .optionallyWith(
        vpceServiceName.map(value =>
          VPCEServiceName.unwrap(value): java.lang.String
        )
      )(_.vpceServiceName)
      .optionallyWith(
        serviceDnsName.map(value =>
          ServiceDnsName.unwrap(value): java.lang.String
        )
      )(_.serviceDnsName)
      .optionallyWith(
        vpceConfigurationDescription.map(value =>
          VPCEConfigurationDescription.unwrap(value): java.lang.String
        )
      )(_.vpceConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateVpceConfigurationRequest.ReadOnly =
    zio.aws.devicefarm.model.UpdateVpceConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateVpceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateVpceConfigurationRequest =
      zio.aws.devicefarm.model.UpdateVpceConfigurationRequest(
        arn,
        vpceConfigurationName.map(value => value),
        vpceServiceName.map(value => value),
        serviceDnsName.map(value => value),
        vpceConfigurationDescription.map(value => value)
      )
    def arn: AmazonResourceName
    def vpceConfigurationName: Optional[VPCEConfigurationName]
    def vpceServiceName: Optional[VPCEServiceName]
    def serviceDnsName: Optional[ServiceDnsName]
    def vpceConfigurationDescription: Optional[VPCEConfigurationDescription]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getVpceConfigurationName: ZIO[Any, AwsError, VPCEConfigurationName] =
      AwsError.unwrapOptionField("vpceConfigurationName", vpceConfigurationName)
    def getVpceServiceName: ZIO[Any, AwsError, VPCEServiceName] =
      AwsError.unwrapOptionField("vpceServiceName", vpceServiceName)
    def getServiceDnsName: ZIO[Any, AwsError, ServiceDnsName] =
      AwsError.unwrapOptionField("serviceDnsName", serviceDnsName)
    def getVpceConfigurationDescription
        : ZIO[Any, AwsError, VPCEConfigurationDescription] =
      AwsError.unwrapOptionField(
        "vpceConfigurationDescription",
        vpceConfigurationDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest
  ) extends zio.aws.devicefarm.model.UpdateVpceConfigurationRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val vpceConfigurationName: Optional[VPCEConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpceConfigurationName())
        .map(value =>
          zio.aws.devicefarm.model.primitives.VPCEConfigurationName(value)
        )
    override val vpceServiceName: Optional[VPCEServiceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpceServiceName())
        .map(value =>
          zio.aws.devicefarm.model.primitives.VPCEServiceName(value)
        )
    override val serviceDnsName: Optional[ServiceDnsName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceDnsName())
        .map(value => zio.aws.devicefarm.model.primitives.ServiceDnsName(value))
    override val vpceConfigurationDescription
        : Optional[VPCEConfigurationDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.vpceConfigurationDescription())
      .map(value =>
        zio.aws.devicefarm.model.primitives.VPCEConfigurationDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest
  ): zio.aws.devicefarm.model.UpdateVpceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
