package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  NonEmptyString,
  SubnetId,
  SecurityGroupId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VpcConfig(
    securityGroupIds: Iterable[SecurityGroupId],
    subnetIds: Iterable[SubnetId],
    vpcId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.VpcConfig = {
    import VpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.VpcConfig
      .builder()
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .vpcId(NonEmptyString.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.VpcConfig.ReadOnly =
    zio.aws.devicefarm.model.VpcConfig.wrap(buildAwsValue())
}
object VpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.VpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.VpcConfig =
      zio.aws.devicefarm.model.VpcConfig(securityGroupIds, subnetIds, vpcId)
    def securityGroupIds: List[SecurityGroupId]
    def subnetIds: List[SubnetId]
    def vpcId: NonEmptyString
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getVpcId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.VpcConfig
  ) extends zio.aws.devicefarm.model.VpcConfig.ReadOnly {
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.devicefarm.model.primitives.SecurityGroupId(item)
      }
      .toList
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.devicefarm.model.primitives.SubnetId(item)
      }
      .toList
    override val vpcId: NonEmptyString =
      zio.aws.devicefarm.model.primitives.NonEmptyString(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.VpcConfig
  ): zio.aws.devicefarm.model.VpcConfig.ReadOnly = new Wrapper(impl)
}
