package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AllocateTransitVirtualInterfaceResponse(
    virtualInterface: Optional[zio.aws.directconnect.model.VirtualInterface] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse = {
    import AllocateTransitVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse
      .builder()
      .optionallyWith(virtualInterface.map(value => value.buildAwsValue()))(
        _.virtualInterface
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse.ReadOnly =
    zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse
      .wrap(buildAwsValue())
}
object AllocateTransitVirtualInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse =
      zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse(
        virtualInterface.map(value => value.asEditable)
      )
    def virtualInterface
        : Optional[zio.aws.directconnect.model.VirtualInterface.ReadOnly]
    def getVirtualInterface: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.VirtualInterface.ReadOnly
    ] = AwsError.unwrapOptionField("virtualInterface", virtualInterface)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse
  ) extends zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse.ReadOnly {
    override val virtualInterface
        : Optional[zio.aws.directconnect.model.VirtualInterface.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterface())
        .map(value => zio.aws.directconnect.model.VirtualInterface.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse
  ): zio.aws.directconnect.model.AllocateTransitVirtualInterfaceResponse.ReadOnly =
    new Wrapper(impl)
}
