package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class AssociateHostedConnectionRequest(
    connectionId: ConnectionId,
    parentConnectionId: ConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest = {
    import AssociateHostedConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .parentConnectionId(
        ConnectionId.unwrap(parentConnectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AssociateHostedConnectionRequest.ReadOnly =
    zio.aws.directconnect.model.AssociateHostedConnectionRequest
      .wrap(buildAwsValue())
}
object AssociateHostedConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AssociateHostedConnectionRequest =
      zio.aws.directconnect.model
        .AssociateHostedConnectionRequest(connectionId, parentConnectionId)
    def connectionId: ConnectionId
    def parentConnectionId: ConnectionId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getParentConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(parentConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest
  ) extends zio.aws.directconnect.model.AssociateHostedConnectionRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val parentConnectionId: ConnectionId =
      zio.aws.directconnect.model.primitives
        .ConnectionId(impl.parentConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest
  ): zio.aws.directconnect.model.AssociateHostedConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
