package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  VirtualInterfaceId
}
import scala.jdk.CollectionConverters.*
final case class ConfirmTransitVirtualInterfaceRequest(
    virtualInterfaceId: VirtualInterfaceId,
    directConnectGatewayId: DirectConnectGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest = {
    import ConfirmTransitVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest
      .builder()
      .virtualInterfaceId(
        VirtualInterfaceId.unwrap(virtualInterfaceId): java.lang.String
      )
      .directConnectGatewayId(
        DirectConnectGatewayId.unwrap(directConnectGatewayId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object ConfirmTransitVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceRequest =
      zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceRequest(
        virtualInterfaceId,
        directConnectGatewayId
      )
    def virtualInterfaceId: VirtualInterfaceId
    def directConnectGatewayId: DirectConnectGatewayId
    def getVirtualInterfaceId: ZIO[Any, Nothing, VirtualInterfaceId] =
      ZIO.succeed(virtualInterfaceId)
    def getDirectConnectGatewayId: ZIO[Any, Nothing, DirectConnectGatewayId] =
      ZIO.succeed(directConnectGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceRequest.ReadOnly {
    override val virtualInterfaceId: VirtualInterfaceId =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceId(impl.virtualInterfaceId())
    override val directConnectGatewayId: DirectConnectGatewayId =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayId(impl.directConnectGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest
  ): zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
