package zio.aws.directconnect.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionState {
  def unwrap
      : software.amazon.awssdk.services.directconnect.model.ConnectionState
}
object ConnectionState {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.ConnectionState
  ): zio.aws.directconnect.model.ConnectionState = value match {
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.ORDERING =>
      val r = ordering
      r
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.REQUESTED =>
      val r = requested
      r
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.DOWN =>
      val r = down
      r
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.REJECTED =>
      val r = rejected
      r
    case software.amazon.awssdk.services.directconnect.model.ConnectionState.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.UNKNOWN_TO_SDK_VERSION
  }
  case object ordering extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.ORDERING
  }
  case object requested extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.REQUESTED
  }
  case object pending extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.PENDING
  }
  case object available extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.AVAILABLE
  }
  case object down extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.DOWN
  }
  case object deleting extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.DELETING
  }
  case object deleted extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.DELETED
  }
  case object rejected extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.REJECTED
  }
  case object unknown extends zio.aws.directconnect.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.ConnectionState =
      software.amazon.awssdk.services.directconnect.model.ConnectionState.UNKNOWN
  }
}
