package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  GatewayIdToAssociate,
  OwnerAccount,
  DirectConnectGatewayId
}
import scala.jdk.CollectionConverters.*
final case class CreateDirectConnectGatewayAssociationProposalRequest(
    directConnectGatewayId: DirectConnectGatewayId,
    directConnectGatewayOwnerAccount: OwnerAccount,
    gatewayId: GatewayIdToAssociate,
    addAllowedPrefixesToDirectConnectGateway: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent,
    removeAllowedPrefixesToDirectConnectGateway: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest = {
    import CreateDirectConnectGatewayAssociationProposalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
      .builder()
      .directConnectGatewayId(
        DirectConnectGatewayId.unwrap(directConnectGatewayId): java.lang.String
      )
      .directConnectGatewayOwnerAccount(
        OwnerAccount.unwrap(directConnectGatewayOwnerAccount): java.lang.String
      )
      .gatewayId(GatewayIdToAssociate.unwrap(gatewayId): java.lang.String)
      .optionallyWith(
        addAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addAllowedPrefixesToDirectConnectGateway)
      .optionallyWith(
        removeAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeAllowedPrefixesToDirectConnectGateway)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest.ReadOnly =
    zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
      .wrap(buildAwsValue())
}
object CreateDirectConnectGatewayAssociationProposalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest =
      zio.aws.directconnect.model
        .CreateDirectConnectGatewayAssociationProposalRequest(
          directConnectGatewayId,
          directConnectGatewayOwnerAccount,
          gatewayId,
          addAllowedPrefixesToDirectConnectGateway.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          removeAllowedPrefixesToDirectConnectGateway.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def directConnectGatewayId: DirectConnectGatewayId
    def directConnectGatewayOwnerAccount: OwnerAccount
    def gatewayId: GatewayIdToAssociate
    def addAllowedPrefixesToDirectConnectGateway
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def removeAllowedPrefixesToDirectConnectGateway
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def getDirectConnectGatewayId: ZIO[Any, Nothing, DirectConnectGatewayId] =
      ZIO.succeed(directConnectGatewayId)
    def getDirectConnectGatewayOwnerAccount: ZIO[Any, Nothing, OwnerAccount] =
      ZIO.succeed(directConnectGatewayOwnerAccount)
    def getGatewayId: ZIO[Any, Nothing, GatewayIdToAssociate] =
      ZIO.succeed(gatewayId)
    def getAddAllowedPrefixesToDirectConnectGateway: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "addAllowedPrefixesToDirectConnectGateway",
      addAllowedPrefixesToDirectConnectGateway
    )
    def getRemoveAllowedPrefixesToDirectConnectGateway: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "removeAllowedPrefixesToDirectConnectGateway",
      removeAllowedPrefixesToDirectConnectGateway
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
  ) extends zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest.ReadOnly {
    override val directConnectGatewayId: DirectConnectGatewayId =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayId(impl.directConnectGatewayId())
    override val directConnectGatewayOwnerAccount: OwnerAccount =
      zio.aws.directconnect.model.primitives
        .OwnerAccount(impl.directConnectGatewayOwnerAccount())
    override val gatewayId: GatewayIdToAssociate =
      zio.aws.directconnect.model.primitives
        .GatewayIdToAssociate(impl.gatewayId())
    override val addAllowedPrefixesToDirectConnectGateway: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.addAllowedPrefixesToDirectConnectGateway())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
    override val removeAllowedPrefixesToDirectConnectGateway: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.removeAllowedPrefixesToDirectConnectGateway())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
  ): zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest.ReadOnly =
    new Wrapper(impl)
}
