package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  ConnectionId,
  ProviderName,
  LagName,
  Count,
  Bandwidth,
  RequestMACSec,
  LocationCode
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateLagRequest(
    numberOfConnections: Count,
    location: LocationCode,
    connectionsBandwidth: Bandwidth,
    lagName: LagName,
    connectionId: Optional[ConnectionId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.directconnect.model.Tag]] = Optional.Absent,
    childConnectionTags: Optional[Iterable[zio.aws.directconnect.model.Tag]] =
      Optional.Absent,
    providerName: Optional[ProviderName] = Optional.Absent,
    requestMACSec: Optional[RequestMACSec] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateLagRequest = {
    import CreateLagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateLagRequest
      .builder()
      .numberOfConnections(Count.unwrap(numberOfConnections): Integer)
      .location(LocationCode.unwrap(location): java.lang.String)
      .connectionsBandwidth(
        Bandwidth.unwrap(connectionsBandwidth): java.lang.String
      )
      .lagName(LagName.unwrap(lagName): java.lang.String)
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        childConnectionTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.childConnectionTags)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .optionallyWith(
        requestMACSec.map(value =>
          RequestMACSec.unwrap(value): java.lang.Boolean
        )
      )(_.requestMACSec)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.CreateLagRequest.ReadOnly =
    zio.aws.directconnect.model.CreateLagRequest.wrap(buildAwsValue())
}
object CreateLagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateLagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.CreateLagRequest =
      zio.aws.directconnect.model.CreateLagRequest(
        numberOfConnections,
        location,
        connectionsBandwidth,
        lagName,
        connectionId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        childConnectionTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        providerName.map(value => value),
        requestMACSec.map(value => value)
      )
    def numberOfConnections: Count
    def location: LocationCode
    def connectionsBandwidth: Bandwidth
    def lagName: LagName
    def connectionId: Optional[ConnectionId]
    def tags: Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def childConnectionTags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def providerName: Optional[ProviderName]
    def requestMACSec: Optional[RequestMACSec]
    def getNumberOfConnections: ZIO[Any, Nothing, Count] =
      ZIO.succeed(numberOfConnections)
    def getLocation: ZIO[Any, Nothing, LocationCode] = ZIO.succeed(location)
    def getConnectionsBandwidth: ZIO[Any, Nothing, Bandwidth] =
      ZIO.succeed(connectionsBandwidth)
    def getLagName: ZIO[Any, Nothing, LagName] = ZIO.succeed(lagName)
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getChildConnectionTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("childConnectionTags", childConnectionTags)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getRequestMACSec: ZIO[Any, AwsError, RequestMACSec] =
      AwsError.unwrapOptionField("requestMACSec", requestMACSec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateLagRequest
  ) extends zio.aws.directconnect.model.CreateLagRequest.ReadOnly {
    override val numberOfConnections: Count =
      zio.aws.directconnect.model.primitives.Count(impl.numberOfConnections())
    override val location: LocationCode =
      zio.aws.directconnect.model.primitives.LocationCode(impl.location())
    override val connectionsBandwidth: Bandwidth =
      zio.aws.directconnect.model.primitives
        .Bandwidth(impl.connectionsBandwidth())
    override val lagName: LagName =
      zio.aws.directconnect.model.primitives.LagName(impl.lagName())
    override val connectionId: Optional[ConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => zio.aws.directconnect.model.primitives.ConnectionId(value))
    override val tags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val childConnectionTags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childConnectionTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val providerName: Optional[ProviderName] = zio.aws.core.internal
      .optionalFromNullable(impl.providerName())
      .map(value => zio.aws.directconnect.model.primitives.ProviderName(value))
    override val requestMACSec: Optional[RequestMACSec] = zio.aws.core.internal
      .optionalFromNullable(impl.requestMACSec())
      .map(value => zio.aws.directconnect.model.primitives.RequestMACSec(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateLagRequest
  ): zio.aws.directconnect.model.CreateLagRequest.ReadOnly = new Wrapper(impl)
}
