package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class CreatePrivateVirtualInterfaceRequest(
    connectionId: ConnectionId,
    newPrivateVirtualInterface: zio.aws.directconnect.model.NewPrivateVirtualInterface
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest = {
    import CreatePrivateVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .newPrivateVirtualInterface(newPrivateVirtualInterface.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.CreatePrivateVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.CreatePrivateVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object CreatePrivateVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.CreatePrivateVirtualInterfaceRequest =
      zio.aws.directconnect.model.CreatePrivateVirtualInterfaceRequest(
        connectionId,
        newPrivateVirtualInterface.asEditable
      )
    def connectionId: ConnectionId
    def newPrivateVirtualInterface
        : zio.aws.directconnect.model.NewPrivateVirtualInterface.ReadOnly
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getNewPrivateVirtualInterface: ZIO[
      Any,
      Nothing,
      zio.aws.directconnect.model.NewPrivateVirtualInterface.ReadOnly
    ] = ZIO.succeed(newPrivateVirtualInterface)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.CreatePrivateVirtualInterfaceRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val newPrivateVirtualInterface
        : zio.aws.directconnect.model.NewPrivateVirtualInterface.ReadOnly =
      zio.aws.directconnect.model.NewPrivateVirtualInterface
        .wrap(impl.newPrivateVirtualInterface())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest
  ): zio.aws.directconnect.model.CreatePrivateVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
