package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class CreateTransitVirtualInterfaceRequest(
    connectionId: ConnectionId,
    newTransitVirtualInterface: zio.aws.directconnect.model.NewTransitVirtualInterface
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest = {
    import CreateTransitVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .newTransitVirtualInterface(newTransitVirtualInterface.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.CreateTransitVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.CreateTransitVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object CreateTransitVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.CreateTransitVirtualInterfaceRequest =
      zio.aws.directconnect.model.CreateTransitVirtualInterfaceRequest(
        connectionId,
        newTransitVirtualInterface.asEditable
      )
    def connectionId: ConnectionId
    def newTransitVirtualInterface
        : zio.aws.directconnect.model.NewTransitVirtualInterface.ReadOnly
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getNewTransitVirtualInterface: ZIO[
      Any,
      Nothing,
      zio.aws.directconnect.model.NewTransitVirtualInterface.ReadOnly
    ] = ZIO.succeed(newTransitVirtualInterface)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.CreateTransitVirtualInterfaceRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val newTransitVirtualInterface
        : zio.aws.directconnect.model.NewTransitVirtualInterface.ReadOnly =
      zio.aws.directconnect.model.NewTransitVirtualInterface
        .wrap(impl.newTransitVirtualInterface())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest
  ): zio.aws.directconnect.model.CreateTransitVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
