package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.InterconnectId
import scala.jdk.CollectionConverters.*
final case class DescribeInterconnectsRequest(
    interconnectId: Optional[InterconnectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest = {
    import DescribeInterconnectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest
      .builder()
      .optionallyWith(
        interconnectId.map(value =>
          InterconnectId.unwrap(value): java.lang.String
        )
      )(_.interconnectId)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeInterconnectsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeInterconnectsRequest
      .wrap(buildAwsValue())
}
object DescribeInterconnectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeInterconnectsRequest =
      zio.aws.directconnect.model
        .DescribeInterconnectsRequest(interconnectId.map(value => value))
    def interconnectId: Optional[InterconnectId]
    def getInterconnectId: ZIO[Any, AwsError, InterconnectId] =
      AwsError.unwrapOptionField("interconnectId", interconnectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest
  ) extends zio.aws.directconnect.model.DescribeInterconnectsRequest.ReadOnly {
    override val interconnectId: Optional[InterconnectId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interconnectId())
        .map(value =>
          zio.aws.directconnect.model.primitives.InterconnectId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest
  ): zio.aws.directconnect.model.DescribeInterconnectsRequest.ReadOnly =
    new Wrapper(impl)
}
