package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeTagsResponse(
    resourceTags: Optional[Iterable[zio.aws.directconnect.model.ResourceTag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse = {
    import DescribeTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse
      .builder()
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DescribeTagsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeTagsResponse.wrap(buildAwsValue())
}
object DescribeTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeTagsResponse =
      zio.aws.directconnect.model.DescribeTagsResponse(
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceTags
        : Optional[List[zio.aws.directconnect.model.ResourceTag.ReadOnly]]
    def getResourceTags: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.ResourceTag.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceTags", resourceTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse
  ) extends zio.aws.directconnect.model.DescribeTagsResponse.ReadOnly {
    override val resourceTags
        : Optional[List[zio.aws.directconnect.model.ResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.ResourceTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse
  ): zio.aws.directconnect.model.DescribeTagsResponse.ReadOnly = new Wrapper(
    impl
  )
}
