package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  OwnerAccount,
  VirtualInterfaceRegion,
  StateChangeError,
  VirtualInterfaceId
}
import scala.jdk.CollectionConverters.*
final case class DirectConnectGatewayAttachment(
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent,
    virtualInterfaceId: Optional[VirtualInterfaceId] = Optional.Absent,
    virtualInterfaceRegion: Optional[VirtualInterfaceRegion] = Optional.Absent,
    virtualInterfaceOwnerAccount: Optional[OwnerAccount] = Optional.Absent,
    attachmentState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
    ] = Optional.Absent,
    attachmentType: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentType
    ] = Optional.Absent,
    stateChangeError: Optional[StateChangeError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment = {
    import DirectConnectGatewayAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment
      .builder()
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(
        virtualInterfaceRegion.map(value =>
          VirtualInterfaceRegion.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceRegion)
      .optionallyWith(
        virtualInterfaceOwnerAccount.map(value =>
          OwnerAccount.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceOwnerAccount)
      .optionallyWith(attachmentState.map(value => value.unwrap))(
        _.attachmentState
      )
      .optionallyWith(attachmentType.map(value => value.unwrap))(
        _.attachmentType
      )
      .optionallyWith(
        stateChangeError.map(value =>
          StateChangeError.unwrap(value): java.lang.String
        )
      )(_.stateChangeError)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly =
    zio.aws.directconnect.model.DirectConnectGatewayAttachment
      .wrap(buildAwsValue())
}
object DirectConnectGatewayAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DirectConnectGatewayAttachment =
      zio.aws.directconnect.model.DirectConnectGatewayAttachment(
        directConnectGatewayId.map(value => value),
        virtualInterfaceId.map(value => value),
        virtualInterfaceRegion.map(value => value),
        virtualInterfaceOwnerAccount.map(value => value),
        attachmentState.map(value => value),
        attachmentType.map(value => value),
        stateChangeError.map(value => value)
      )
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def virtualInterfaceId: Optional[VirtualInterfaceId]
    def virtualInterfaceRegion: Optional[VirtualInterfaceRegion]
    def virtualInterfaceOwnerAccount: Optional[OwnerAccount]
    def attachmentState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
    ]
    def attachmentType: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentType
    ]
    def stateChangeError: Optional[StateChangeError]
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getVirtualInterfaceRegion: ZIO[Any, AwsError, VirtualInterfaceRegion] =
      AwsError.unwrapOptionField(
        "virtualInterfaceRegion",
        virtualInterfaceRegion
      )
    def getVirtualInterfaceOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField(
        "virtualInterfaceOwnerAccount",
        virtualInterfaceOwnerAccount
      )
    def getAttachmentState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
    ] = AwsError.unwrapOptionField("attachmentState", attachmentState)
    def getAttachmentType: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentType
    ] = AwsError.unwrapOptionField("attachmentType", attachmentType)
    def getStateChangeError: ZIO[Any, AwsError, StateChangeError] =
      AwsError.unwrapOptionField("stateChangeError", stateChangeError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment
  ) extends zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly {
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
    override val virtualInterfaceId: Optional[VirtualInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
        )
    override val virtualInterfaceRegion: Optional[VirtualInterfaceRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceRegion())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceRegion(value)
        )
    override val virtualInterfaceOwnerAccount: Optional[OwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceOwnerAccount())
        .map(value =>
          zio.aws.directconnect.model.primitives.OwnerAccount(value)
        )
    override val attachmentState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentState())
      .map(value =>
        zio.aws.directconnect.model.DirectConnectGatewayAttachmentState
          .wrap(value)
      )
    override val attachmentType: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAttachmentType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentType())
      .map(value =>
        zio.aws.directconnect.model.DirectConnectGatewayAttachmentType
          .wrap(value)
      )
    override val stateChangeError: Optional[StateChangeError] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateChangeError())
        .map(value =>
          zio.aws.directconnect.model.primitives.StateChangeError(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment
  ): zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly =
    new Wrapper(impl)
}
