package zio.aws.directconnect.model
import scala.jdk.CollectionConverters.*
sealed trait GatewayType {
  def unwrap: software.amazon.awssdk.services.directconnect.model.GatewayType
}
object GatewayType {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.GatewayType
  ): zio.aws.directconnect.model.GatewayType = value match {
    case software.amazon.awssdk.services.directconnect.model.GatewayType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.GatewayType.VIRTUAL_PRIVATE_GATEWAY =>
      val r = virtualPrivateGateway
      r
    case software.amazon.awssdk.services.directconnect.model.GatewayType.TRANSIT_GATEWAY =>
      val r = transitGateway
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.GatewayType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.GatewayType =
      software.amazon.awssdk.services.directconnect.model.GatewayType.UNKNOWN_TO_SDK_VERSION
  }
  case object virtualPrivateGateway
      extends zio.aws.directconnect.model.GatewayType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.GatewayType =
      software.amazon.awssdk.services.directconnect.model.GatewayType.VIRTUAL_PRIVATE_GATEWAY
  }
  case object transitGateway extends zio.aws.directconnect.model.GatewayType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.GatewayType =
      software.amazon.awssdk.services.directconnect.model.GatewayType.TRANSIT_GATEWAY
  }
}
