package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  ProviderName,
  AwsDeviceV2,
  Bandwidth,
  Region,
  AwsLogicalDeviceId,
  AwsDevice,
  InterconnectId,
  JumboFrameCapable,
  InterconnectName,
  LagId,
  LocationCode,
  LoaIssueTime
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Interconnect(
    interconnectId: Optional[InterconnectId] = Optional.Absent,
    interconnectName: Optional[InterconnectName] = Optional.Absent,
    interconnectState: Optional[zio.aws.directconnect.model.InterconnectState] =
      Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    location: Optional[LocationCode] = Optional.Absent,
    bandwidth: Optional[Bandwidth] = Optional.Absent,
    loaIssueTime: Optional[LoaIssueTime] = Optional.Absent,
    lagId: Optional[LagId] = Optional.Absent,
    awsDevice: Optional[AwsDevice] = Optional.Absent,
    jumboFrameCapable: Optional[JumboFrameCapable] = Optional.Absent,
    awsDeviceV2: Optional[AwsDeviceV2] = Optional.Absent,
    awsLogicalDeviceId: Optional[AwsLogicalDeviceId] = Optional.Absent,
    hasLogicalRedundancy: Optional[
      zio.aws.directconnect.model.HasLogicalRedundancy
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.directconnect.model.Tag]] = Optional.Absent,
    providerName: Optional[ProviderName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.Interconnect = {
    import Interconnect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.Interconnect
      .builder()
      .optionallyWith(
        interconnectId.map(value =>
          InterconnectId.unwrap(value): java.lang.String
        )
      )(_.interconnectId)
      .optionallyWith(
        interconnectName.map(value =>
          InterconnectName.unwrap(value): java.lang.String
        )
      )(_.interconnectName)
      .optionallyWith(interconnectState.map(value => value.unwrap))(
        _.interconnectState
      )
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        location.map(value => LocationCode.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        bandwidth.map(value => Bandwidth.unwrap(value): java.lang.String)
      )(_.bandwidth)
      .optionallyWith(
        loaIssueTime.map(value => LoaIssueTime.unwrap(value): Instant)
      )(_.loaIssueTime)
      .optionallyWith(
        lagId.map(value => LagId.unwrap(value): java.lang.String)
      )(_.lagId)
      .optionallyWith(
        awsDevice.map(value => AwsDevice.unwrap(value): java.lang.String)
      )(_.awsDevice)
      .optionallyWith(
        jumboFrameCapable.map(value =>
          JumboFrameCapable.unwrap(value): java.lang.Boolean
        )
      )(_.jumboFrameCapable)
      .optionallyWith(
        awsDeviceV2.map(value => AwsDeviceV2.unwrap(value): java.lang.String)
      )(_.awsDeviceV2)
      .optionallyWith(
        awsLogicalDeviceId.map(value =>
          AwsLogicalDeviceId.unwrap(value): java.lang.String
        )
      )(_.awsLogicalDeviceId)
      .optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(
        _.hasLogicalRedundancy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.Interconnect.ReadOnly =
    zio.aws.directconnect.model.Interconnect.wrap(buildAwsValue())
}
object Interconnect {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.Interconnect
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.Interconnect =
      zio.aws.directconnect.model.Interconnect(
        interconnectId.map(value => value),
        interconnectName.map(value => value),
        interconnectState.map(value => value),
        region.map(value => value),
        location.map(value => value),
        bandwidth.map(value => value),
        loaIssueTime.map(value => value),
        lagId.map(value => value),
        awsDevice.map(value => value),
        jumboFrameCapable.map(value => value),
        awsDeviceV2.map(value => value),
        awsLogicalDeviceId.map(value => value),
        hasLogicalRedundancy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        providerName.map(value => value)
      )
    def interconnectId: Optional[InterconnectId]
    def interconnectName: Optional[InterconnectName]
    def interconnectState
        : Optional[zio.aws.directconnect.model.InterconnectState]
    def region: Optional[Region]
    def location: Optional[LocationCode]
    def bandwidth: Optional[Bandwidth]
    def loaIssueTime: Optional[LoaIssueTime]
    def lagId: Optional[LagId]
    def awsDevice: Optional[AwsDevice]
    def jumboFrameCapable: Optional[JumboFrameCapable]
    def awsDeviceV2: Optional[AwsDeviceV2]
    def awsLogicalDeviceId: Optional[AwsLogicalDeviceId]
    def hasLogicalRedundancy
        : Optional[zio.aws.directconnect.model.HasLogicalRedundancy]
    def tags: Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def providerName: Optional[ProviderName]
    def getInterconnectId: ZIO[Any, AwsError, InterconnectId] =
      AwsError.unwrapOptionField("interconnectId", interconnectId)
    def getInterconnectName: ZIO[Any, AwsError, InterconnectName] =
      AwsError.unwrapOptionField("interconnectName", interconnectName)
    def getInterconnectState
        : ZIO[Any, AwsError, zio.aws.directconnect.model.InterconnectState] =
      AwsError.unwrapOptionField("interconnectState", interconnectState)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getLocation: ZIO[Any, AwsError, LocationCode] =
      AwsError.unwrapOptionField("location", location)
    def getBandwidth: ZIO[Any, AwsError, Bandwidth] =
      AwsError.unwrapOptionField("bandwidth", bandwidth)
    def getLoaIssueTime: ZIO[Any, AwsError, LoaIssueTime] =
      AwsError.unwrapOptionField("loaIssueTime", loaIssueTime)
    def getLagId: ZIO[Any, AwsError, LagId] =
      AwsError.unwrapOptionField("lagId", lagId)
    def getAwsDevice: ZIO[Any, AwsError, AwsDevice] =
      AwsError.unwrapOptionField("awsDevice", awsDevice)
    def getJumboFrameCapable: ZIO[Any, AwsError, JumboFrameCapable] =
      AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapable)
    def getAwsDeviceV2: ZIO[Any, AwsError, AwsDeviceV2] =
      AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2)
    def getAwsLogicalDeviceId: ZIO[Any, AwsError, AwsLogicalDeviceId] =
      AwsError.unwrapOptionField("awsLogicalDeviceId", awsLogicalDeviceId)
    def getHasLogicalRedundancy
        : ZIO[Any, AwsError, zio.aws.directconnect.model.HasLogicalRedundancy] =
      AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.Interconnect
  ) extends zio.aws.directconnect.model.Interconnect.ReadOnly {
    override val interconnectId: Optional[InterconnectId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interconnectId())
        .map(value =>
          zio.aws.directconnect.model.primitives.InterconnectId(value)
        )
    override val interconnectName: Optional[InterconnectName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interconnectName())
        .map(value =>
          zio.aws.directconnect.model.primitives.InterconnectName(value)
        )
    override val interconnectState
        : Optional[zio.aws.directconnect.model.InterconnectState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interconnectState())
        .map(value => zio.aws.directconnect.model.InterconnectState.wrap(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.directconnect.model.primitives.Region(value))
    override val location: Optional[LocationCode] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.directconnect.model.primitives.LocationCode(value))
    override val bandwidth: Optional[Bandwidth] = zio.aws.core.internal
      .optionalFromNullable(impl.bandwidth())
      .map(value => zio.aws.directconnect.model.primitives.Bandwidth(value))
    override val loaIssueTime: Optional[LoaIssueTime] = zio.aws.core.internal
      .optionalFromNullable(impl.loaIssueTime())
      .map(value => zio.aws.directconnect.model.primitives.LoaIssueTime(value))
    override val lagId: Optional[LagId] = zio.aws.core.internal
      .optionalFromNullable(impl.lagId())
      .map(value => zio.aws.directconnect.model.primitives.LagId(value))
    override val awsDevice: Optional[AwsDevice] = zio.aws.core.internal
      .optionalFromNullable(impl.awsDevice())
      .map(value => zio.aws.directconnect.model.primitives.AwsDevice(value))
    override val jumboFrameCapable: Optional[JumboFrameCapable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jumboFrameCapable())
        .map(value =>
          zio.aws.directconnect.model.primitives.JumboFrameCapable(value)
        )
    override val awsDeviceV2: Optional[AwsDeviceV2] = zio.aws.core.internal
      .optionalFromNullable(impl.awsDeviceV2())
      .map(value => zio.aws.directconnect.model.primitives.AwsDeviceV2(value))
    override val awsLogicalDeviceId: Optional[AwsLogicalDeviceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsLogicalDeviceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.AwsLogicalDeviceId(value)
        )
    override val hasLogicalRedundancy
        : Optional[zio.aws.directconnect.model.HasLogicalRedundancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hasLogicalRedundancy())
        .map(value =>
          zio.aws.directconnect.model.HasLogicalRedundancy.wrap(value)
        )
    override val tags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val providerName: Optional[ProviderName] = zio.aws.core.internal
      .optionalFromNullable(impl.providerName())
      .map(value => zio.aws.directconnect.model.primitives.ProviderName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.Interconnect
  ): zio.aws.directconnect.model.Interconnect.ReadOnly = new Wrapper(impl)
}
