package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  FailureTestHistoryStatus,
  PaginationToken,
  MaxResultSetSize,
  VirtualInterfaceId,
  TestId,
  BGPPeerId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListVirtualInterfaceTestHistoryRequest(
    testId: Optional[TestId] = Optional.Absent,
    virtualInterfaceId: Optional[VirtualInterfaceId] = Optional.Absent,
    bgpPeers: Optional[Iterable[BGPPeerId]] = Optional.Absent,
    status: Optional[FailureTestHistoryStatus] = Optional.Absent,
    maxResults: Optional[MaxResultSetSize] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest = {
    import ListVirtualInterfaceTestHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
      .builder()
      .optionallyWith(
        testId.map(value => TestId.unwrap(value): java.lang.String)
      )(_.testId)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(
        bgpPeers.map(value =>
          value.map { item =>
            BGPPeerId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bgpPeers)
      .optionallyWith(
        status.map(value =>
          FailureTestHistoryStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .optionallyWith(
        maxResults.map(value => MaxResultSetSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest.ReadOnly =
    zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest
      .wrap(buildAwsValue())
}
object ListVirtualInterfaceTestHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest =
      zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest(
        testId.map(value => value),
        virtualInterfaceId.map(value => value),
        bgpPeers.map(value => value),
        status.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def testId: Optional[TestId]
    def virtualInterfaceId: Optional[VirtualInterfaceId]
    def bgpPeers: Optional[List[BGPPeerId]]
    def status: Optional[FailureTestHistoryStatus]
    def maxResults: Optional[MaxResultSetSize]
    def nextToken: Optional[PaginationToken]
    def getTestId: ZIO[Any, AwsError, TestId] =
      AwsError.unwrapOptionField("testId", testId)
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getBgpPeers: ZIO[Any, AwsError, List[BGPPeerId]] =
      AwsError.unwrapOptionField("bgpPeers", bgpPeers)
    def getStatus: ZIO[Any, AwsError, FailureTestHistoryStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMaxResults: ZIO[Any, AwsError, MaxResultSetSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
  ) extends zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest.ReadOnly {
    override val testId: Optional[TestId] = zio.aws.core.internal
      .optionalFromNullable(impl.testId())
      .map(value => zio.aws.directconnect.model.primitives.TestId(value))
    override val virtualInterfaceId: Optional[VirtualInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
        )
    override val bgpPeers: Optional[List[BGPPeerId]] = zio.aws.core.internal
      .optionalFromNullable(impl.bgpPeers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.primitives.BGPPeerId(item)
        }.toList
      )
    override val status: Optional[FailureTestHistoryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.directconnect.model.primitives.FailureTestHistoryStatus(value)
        )
    override val maxResults: Optional[MaxResultSetSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.directconnect.model.primitives.MaxResultSetSize(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
  ): zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
