package zio.aws.directconnect.model
import scala.jdk.CollectionConverters.*
sealed trait LoaContentType {
  def unwrap: software.amazon.awssdk.services.directconnect.model.LoaContentType
}
object LoaContentType {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.LoaContentType
  ): zio.aws.directconnect.model.LoaContentType = value match {
    case software.amazon.awssdk.services.directconnect.model.LoaContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.LoaContentType.APPLICATION_PDF =>
      val r = `application/pdf`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.LoaContentType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LoaContentType =
      software.amazon.awssdk.services.directconnect.model.LoaContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object `application/pdf`
      extends zio.aws.directconnect.model.LoaContentType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.LoaContentType =
      software.amazon.awssdk.services.directconnect.model.LoaContentType.APPLICATION_PDF
  }
}
