package zio.aws.directconnect.model
import scala.jdk.CollectionConverters.*
sealed trait NniPartnerType {
  def unwrap: software.amazon.awssdk.services.directconnect.model.NniPartnerType
}
object NniPartnerType {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.NniPartnerType
  ): zio.aws.directconnect.model.NniPartnerType = value match {
    case software.amazon.awssdk.services.directconnect.model.NniPartnerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.NniPartnerType.V1 =>
      val r = v1
      r
    case software.amazon.awssdk.services.directconnect.model.NniPartnerType.V2 =>
      val r = v2
      r
    case software.amazon.awssdk.services.directconnect.model.NniPartnerType.NON_PARTNER =>
      val r = nonPartner
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.NniPartnerType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.NniPartnerType =
      software.amazon.awssdk.services.directconnect.model.NniPartnerType.UNKNOWN_TO_SDK_VERSION
  }
  case object v1 extends zio.aws.directconnect.model.NniPartnerType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.NniPartnerType =
      software.amazon.awssdk.services.directconnect.model.NniPartnerType.V1
  }
  case object v2 extends zio.aws.directconnect.model.NniPartnerType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.NniPartnerType =
      software.amazon.awssdk.services.directconnect.model.NniPartnerType.V2
  }
  case object nonPartner extends zio.aws.directconnect.model.NniPartnerType {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.NniPartnerType =
      software.amazon.awssdk.services.directconnect.model.NniPartnerType.NON_PARTNER
  }
}
