package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  EncryptionMode,
  ConnectionName,
  ConnectionId
}
import scala.jdk.CollectionConverters.*
final case class UpdateConnectionRequest(
    connectionId: ConnectionId,
    connectionName: Optional[ConnectionName] = Optional.Absent,
    encryptionMode: Optional[EncryptionMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest = {
    import UpdateConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .optionallyWith(
        connectionName.map(value =>
          ConnectionName.unwrap(value): java.lang.String
        )
      )(_.connectionName)
      .optionallyWith(
        encryptionMode.map(value =>
          EncryptionMode.unwrap(value): java.lang.String
        )
      )(_.encryptionMode)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.UpdateConnectionRequest.ReadOnly =
    zio.aws.directconnect.model.UpdateConnectionRequest.wrap(buildAwsValue())
}
object UpdateConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.UpdateConnectionRequest =
      zio.aws.directconnect.model.UpdateConnectionRequest(
        connectionId,
        connectionName.map(value => value),
        encryptionMode.map(value => value)
      )
    def connectionId: ConnectionId
    def connectionName: Optional[ConnectionName]
    def encryptionMode: Optional[EncryptionMode]
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getConnectionName: ZIO[Any, AwsError, ConnectionName] =
      AwsError.unwrapOptionField("connectionName", connectionName)
    def getEncryptionMode: ZIO[Any, AwsError, EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest
  ) extends zio.aws.directconnect.model.UpdateConnectionRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val connectionName: Optional[ConnectionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionName())
        .map(value =>
          zio.aws.directconnect.model.primitives.ConnectionName(value)
        )
    override val encryptionMode: Optional[EncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMode())
        .map(value =>
          zio.aws.directconnect.model.primitives.EncryptionMode(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest
  ): zio.aws.directconnect.model.UpdateConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
