package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDirectConnectGatewayAssociationResponse(
    directConnectGatewayAssociation: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse = {
    import UpdateDirectConnectGatewayAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse
      .builder()
      .optionallyWith(
        directConnectGatewayAssociation.map(value => value.buildAwsValue())
      )(_.directConnectGatewayAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.ReadOnly =
    zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse
      .wrap(buildAwsValue())
}
object UpdateDirectConnectGatewayAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse =
      zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse(
        directConnectGatewayAssociation.map(value => value.asEditable)
      )
    def directConnectGatewayAssociation: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly
    ]
    def getDirectConnectGatewayAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "directConnectGatewayAssociation",
      directConnectGatewayAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse
  ) extends zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.ReadOnly {
    override val directConnectGatewayAssociation: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.directConnectGatewayAssociation())
      .map(value =>
        zio.aws.directconnect.model.DirectConnectGatewayAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse
  ): zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
