package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  VLAN,
  VirtualInterfaceName,
  OwnerAccount,
  VirtualInterfaceType,
  ConnectionId,
  MTU,
  RouterConfig,
  AwsDeviceV2,
  LongAsn,
  BGPAuthKey,
  Region,
  VirtualGatewayId,
  AwsLogicalDeviceId,
  VirtualInterfaceId,
  JumboFrameCapable,
  SiteLinkEnabled,
  ASN,
  AmazonAddress,
  LocationCode,
  CustomerAddress
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class VirtualInterface(
    ownerAccount: Optional[OwnerAccount] = Optional.Absent,
    virtualInterfaceId: Optional[VirtualInterfaceId] = Optional.Absent,
    location: Optional[LocationCode] = Optional.Absent,
    connectionId: Optional[ConnectionId] = Optional.Absent,
    virtualInterfaceType: Optional[VirtualInterfaceType] = Optional.Absent,
    virtualInterfaceName: Optional[VirtualInterfaceName] = Optional.Absent,
    vlan: Optional[VLAN] = Optional.Absent,
    asn: Optional[ASN] = Optional.Absent,
    amazonSideAsn: Optional[LongAsn] = Optional.Absent,
    authKey: Optional[BGPAuthKey] = Optional.Absent,
    amazonAddress: Optional[AmazonAddress] = Optional.Absent,
    customerAddress: Optional[CustomerAddress] = Optional.Absent,
    addressFamily: Optional[zio.aws.directconnect.model.AddressFamily] =
      Optional.Absent,
    virtualInterfaceState: Optional[
      zio.aws.directconnect.model.VirtualInterfaceState
    ] = Optional.Absent,
    customerRouterConfig: Optional[RouterConfig] = Optional.Absent,
    mtu: Optional[MTU] = Optional.Absent,
    jumboFrameCapable: Optional[JumboFrameCapable] = Optional.Absent,
    virtualGatewayId: Optional[VirtualGatewayId] = Optional.Absent,
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent,
    routeFilterPrefixes: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent,
    bgpPeers: Optional[Iterable[zio.aws.directconnect.model.BGPPeer]] =
      Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    awsDeviceV2: Optional[AwsDeviceV2] = Optional.Absent,
    awsLogicalDeviceId: Optional[AwsLogicalDeviceId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.directconnect.model.Tag]] = Optional.Absent,
    siteLinkEnabled: Optional[SiteLinkEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.VirtualInterface = {
    import VirtualInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.VirtualInterface
      .builder()
      .optionallyWith(
        ownerAccount.map(value => OwnerAccount.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(
        location.map(value => LocationCode.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        virtualInterfaceType.map(value =>
          VirtualInterfaceType.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceType)
      .optionallyWith(
        virtualInterfaceName.map(value =>
          VirtualInterfaceName.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceName)
      .optionallyWith(vlan.map(value => VLAN.unwrap(value): Integer))(_.vlan)
      .optionallyWith(asn.map(value => ASN.unwrap(value): Integer))(_.asn)
      .optionallyWith(
        amazonSideAsn.map(value => LongAsn.unwrap(value): java.lang.Long)
      )(_.amazonSideAsn)
      .optionallyWith(
        authKey.map(value => BGPAuthKey.unwrap(value): java.lang.String)
      )(_.authKey)
      .optionallyWith(
        amazonAddress.map(value =>
          AmazonAddress.unwrap(value): java.lang.String
        )
      )(_.amazonAddress)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(virtualInterfaceState.map(value => value.unwrap))(
        _.virtualInterfaceState
      )
      .optionallyWith(
        customerRouterConfig.map(value =>
          RouterConfig.unwrap(value): java.lang.String
        )
      )(_.customerRouterConfig)
      .optionallyWith(mtu.map(value => MTU.unwrap(value): Integer))(_.mtu)
      .optionallyWith(
        jumboFrameCapable.map(value =>
          JumboFrameCapable.unwrap(value): java.lang.Boolean
        )
      )(_.jumboFrameCapable)
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        routeFilterPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routeFilterPrefixes)
      .optionallyWith(
        bgpPeers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bgpPeers)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        awsDeviceV2.map(value => AwsDeviceV2.unwrap(value): java.lang.String)
      )(_.awsDeviceV2)
      .optionallyWith(
        awsLogicalDeviceId.map(value =>
          AwsLogicalDeviceId.unwrap(value): java.lang.String
        )
      )(_.awsLogicalDeviceId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        siteLinkEnabled.map(value =>
          SiteLinkEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.siteLinkEnabled)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.VirtualInterface.ReadOnly =
    zio.aws.directconnect.model.VirtualInterface.wrap(buildAwsValue())
}
object VirtualInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.VirtualInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.VirtualInterface =
      zio.aws.directconnect.model.VirtualInterface(
        ownerAccount.map(value => value),
        virtualInterfaceId.map(value => value),
        location.map(value => value),
        connectionId.map(value => value),
        virtualInterfaceType.map(value => value),
        virtualInterfaceName.map(value => value),
        vlan.map(value => value),
        asn.map(value => value),
        amazonSideAsn.map(value => value),
        authKey.map(value => value),
        amazonAddress.map(value => value),
        customerAddress.map(value => value),
        addressFamily.map(value => value),
        virtualInterfaceState.map(value => value),
        customerRouterConfig.map(value => value),
        mtu.map(value => value),
        jumboFrameCapable.map(value => value),
        virtualGatewayId.map(value => value),
        directConnectGatewayId.map(value => value),
        routeFilterPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bgpPeers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        region.map(value => value),
        awsDeviceV2.map(value => value),
        awsLogicalDeviceId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        siteLinkEnabled.map(value => value)
      )
    def ownerAccount: Optional[OwnerAccount]
    def virtualInterfaceId: Optional[VirtualInterfaceId]
    def location: Optional[LocationCode]
    def connectionId: Optional[ConnectionId]
    def virtualInterfaceType: Optional[VirtualInterfaceType]
    def virtualInterfaceName: Optional[VirtualInterfaceName]
    def vlan: Optional[VLAN]
    def asn: Optional[ASN]
    def amazonSideAsn: Optional[LongAsn]
    def authKey: Optional[BGPAuthKey]
    def amazonAddress: Optional[AmazonAddress]
    def customerAddress: Optional[CustomerAddress]
    def addressFamily: Optional[zio.aws.directconnect.model.AddressFamily]
    def virtualInterfaceState
        : Optional[zio.aws.directconnect.model.VirtualInterfaceState]
    def customerRouterConfig: Optional[RouterConfig]
    def mtu: Optional[MTU]
    def jumboFrameCapable: Optional[JumboFrameCapable]
    def virtualGatewayId: Optional[VirtualGatewayId]
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def routeFilterPrefixes
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def bgpPeers: Optional[List[zio.aws.directconnect.model.BGPPeer.ReadOnly]]
    def region: Optional[Region]
    def awsDeviceV2: Optional[AwsDeviceV2]
    def awsLogicalDeviceId: Optional[AwsLogicalDeviceId]
    def tags: Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def siteLinkEnabled: Optional[SiteLinkEnabled]
    def getOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getLocation: ZIO[Any, AwsError, LocationCode] =
      AwsError.unwrapOptionField("location", location)
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getVirtualInterfaceType: ZIO[Any, AwsError, VirtualInterfaceType] =
      AwsError.unwrapOptionField("virtualInterfaceType", virtualInterfaceType)
    def getVirtualInterfaceName: ZIO[Any, AwsError, VirtualInterfaceName] =
      AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceName)
    def getVlan: ZIO[Any, AwsError, VLAN] =
      AwsError.unwrapOptionField("vlan", vlan)
    def getAsn: ZIO[Any, AwsError, ASN] = AwsError.unwrapOptionField("asn", asn)
    def getAmazonSideAsn: ZIO[Any, AwsError, LongAsn] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
    def getAuthKey: ZIO[Any, AwsError, BGPAuthKey] =
      AwsError.unwrapOptionField("authKey", authKey)
    def getAmazonAddress: ZIO[Any, AwsError, AmazonAddress] =
      AwsError.unwrapOptionField("amazonAddress", amazonAddress)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
    def getAddressFamily
        : ZIO[Any, AwsError, zio.aws.directconnect.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getVirtualInterfaceState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.VirtualInterfaceState
    ] =
      AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceState)
    def getCustomerRouterConfig: ZIO[Any, AwsError, RouterConfig] =
      AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfig)
    def getMtu: ZIO[Any, AwsError, MTU] = AwsError.unwrapOptionField("mtu", mtu)
    def getJumboFrameCapable: ZIO[Any, AwsError, JumboFrameCapable] =
      AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapable)
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getRouteFilterPrefixes: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField("routeFilterPrefixes", routeFilterPrefixes)
    def getBgpPeers: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.BGPPeer.ReadOnly
    ]] = AwsError.unwrapOptionField("bgpPeers", bgpPeers)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getAwsDeviceV2: ZIO[Any, AwsError, AwsDeviceV2] =
      AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2)
    def getAwsLogicalDeviceId: ZIO[Any, AwsError, AwsLogicalDeviceId] =
      AwsError.unwrapOptionField("awsLogicalDeviceId", awsLogicalDeviceId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSiteLinkEnabled: ZIO[Any, AwsError, SiteLinkEnabled] =
      AwsError.unwrapOptionField("siteLinkEnabled", siteLinkEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.VirtualInterface
  ) extends zio.aws.directconnect.model.VirtualInterface.ReadOnly {
    override val ownerAccount: Optional[OwnerAccount] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => zio.aws.directconnect.model.primitives.OwnerAccount(value))
    override val virtualInterfaceId: Optional[VirtualInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
        )
    override val location: Optional[LocationCode] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.directconnect.model.primitives.LocationCode(value))
    override val connectionId: Optional[ConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => zio.aws.directconnect.model.primitives.ConnectionId(value))
    override val virtualInterfaceType: Optional[VirtualInterfaceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceType())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceType(value)
        )
    override val virtualInterfaceName: Optional[VirtualInterfaceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceName())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceName(value)
        )
    override val vlan: Optional[VLAN] = zio.aws.core.internal
      .optionalFromNullable(impl.vlan())
      .map(value => zio.aws.directconnect.model.primitives.VLAN(value))
    override val asn: Optional[ASN] = zio.aws.core.internal
      .optionalFromNullable(impl.asn())
      .map(value => zio.aws.directconnect.model.primitives.ASN(value))
    override val amazonSideAsn: Optional[LongAsn] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonSideAsn())
      .map(value => zio.aws.directconnect.model.primitives.LongAsn(value))
    override val authKey: Optional[BGPAuthKey] = zio.aws.core.internal
      .optionalFromNullable(impl.authKey())
      .map(value => zio.aws.directconnect.model.primitives.BGPAuthKey(value))
    override val amazonAddress: Optional[AmazonAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonAddress())
      .map(value => zio.aws.directconnect.model.primitives.AmazonAddress(value))
    override val customerAddress: Optional[CustomerAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerAddress())
        .map(value =>
          zio.aws.directconnect.model.primitives.CustomerAddress(value)
        )
    override val addressFamily
        : Optional[zio.aws.directconnect.model.AddressFamily] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressFamily())
        .map(value => zio.aws.directconnect.model.AddressFamily.wrap(value))
    override val virtualInterfaceState
        : Optional[zio.aws.directconnect.model.VirtualInterfaceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceState())
        .map(value =>
          zio.aws.directconnect.model.VirtualInterfaceState.wrap(value)
        )
    override val customerRouterConfig: Optional[RouterConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerRouterConfig())
        .map(value =>
          zio.aws.directconnect.model.primitives.RouterConfig(value)
        )
    override val mtu: Optional[MTU] = zio.aws.core.internal
      .optionalFromNullable(impl.mtu())
      .map(value => zio.aws.directconnect.model.primitives.MTU(value))
    override val jumboFrameCapable: Optional[JumboFrameCapable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jumboFrameCapable())
        .map(value =>
          zio.aws.directconnect.model.primitives.JumboFrameCapable(value)
        )
    override val virtualGatewayId: Optional[VirtualGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
        )
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
    override val routeFilterPrefixes: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routeFilterPrefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
    override val bgpPeers
        : Optional[List[zio.aws.directconnect.model.BGPPeer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bgpPeers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.BGPPeer.wrap(item)
          }.toList
        )
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.directconnect.model.primitives.Region(value))
    override val awsDeviceV2: Optional[AwsDeviceV2] = zio.aws.core.internal
      .optionalFromNullable(impl.awsDeviceV2())
      .map(value => zio.aws.directconnect.model.primitives.AwsDeviceV2(value))
    override val awsLogicalDeviceId: Optional[AwsLogicalDeviceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsLogicalDeviceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.AwsLogicalDeviceId(value)
        )
    override val tags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val siteLinkEnabled: Optional[SiteLinkEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.siteLinkEnabled())
        .map(value =>
          zio.aws.directconnect.model.primitives.SiteLinkEnabled(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.VirtualInterface
  ): zio.aws.directconnect.model.VirtualInterface.ReadOnly = new Wrapper(impl)
}
