package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  OwnerAccount,
  DirectConnectGatewayAssociationProposalId,
  DirectConnectGatewayId
}
import scala.jdk.CollectionConverters.*
final case class AcceptDirectConnectGatewayAssociationProposalRequest(
    directConnectGatewayId: DirectConnectGatewayId,
    proposalId: DirectConnectGatewayAssociationProposalId,
    associatedGatewayOwnerAccount: OwnerAccount,
    overrideAllowedPrefixesToDirectConnectGateway: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest = {
    import AcceptDirectConnectGatewayAssociationProposalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
      .builder()
      .directConnectGatewayId(
        DirectConnectGatewayId.unwrap(directConnectGatewayId): java.lang.String
      )
      .proposalId(
        DirectConnectGatewayAssociationProposalId.unwrap(
          proposalId
        ): java.lang.String
      )
      .associatedGatewayOwnerAccount(
        OwnerAccount.unwrap(associatedGatewayOwnerAccount): java.lang.String
      )
      .optionallyWith(
        overrideAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrideAllowedPrefixesToDirectConnectGateway)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest.ReadOnly =
    zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
      .wrap(buildAwsValue())
}
object AcceptDirectConnectGatewayAssociationProposalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest =
      zio.aws.directconnect.model
        .AcceptDirectConnectGatewayAssociationProposalRequest(
          directConnectGatewayId,
          proposalId,
          associatedGatewayOwnerAccount,
          overrideAllowedPrefixesToDirectConnectGateway.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def directConnectGatewayId: DirectConnectGatewayId
    def proposalId: DirectConnectGatewayAssociationProposalId
    def associatedGatewayOwnerAccount: OwnerAccount
    def overrideAllowedPrefixesToDirectConnectGateway
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def getDirectConnectGatewayId: ZIO[Any, Nothing, DirectConnectGatewayId] =
      ZIO.succeed(directConnectGatewayId)
    def getProposalId
        : ZIO[Any, Nothing, DirectConnectGatewayAssociationProposalId] =
      ZIO.succeed(proposalId)
    def getAssociatedGatewayOwnerAccount: ZIO[Any, Nothing, OwnerAccount] =
      ZIO.succeed(associatedGatewayOwnerAccount)
    def getOverrideAllowedPrefixesToDirectConnectGateway
        : ZIO[Any, AwsError, List[
          zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "overrideAllowedPrefixesToDirectConnectGateway",
      overrideAllowedPrefixesToDirectConnectGateway
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
  ) extends zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest.ReadOnly {
    override val directConnectGatewayId: DirectConnectGatewayId =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayId(impl.directConnectGatewayId())
    override val proposalId: DirectConnectGatewayAssociationProposalId =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayAssociationProposalId(impl.proposalId())
    override val associatedGatewayOwnerAccount: OwnerAccount =
      zio.aws.directconnect.model.primitives
        .OwnerAccount(impl.associatedGatewayOwnerAccount())
    override val overrideAllowedPrefixesToDirectConnectGateway: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.overrideAllowedPrefixesToDirectConnectGateway()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
  ): zio.aws.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest.ReadOnly =
    new Wrapper(impl)
}
