package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.{LagId, ConnectionId}
import scala.jdk.CollectionConverters.*
final case class AssociateConnectionWithLagRequest(
    connectionId: ConnectionId,
    lagId: LagId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest = {
    import AssociateConnectionWithLagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .lagId(LagId.unwrap(lagId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AssociateConnectionWithLagRequest.ReadOnly =
    zio.aws.directconnect.model.AssociateConnectionWithLagRequest
      .wrap(buildAwsValue())
}
object AssociateConnectionWithLagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AssociateConnectionWithLagRequest =
      zio.aws.directconnect.model
        .AssociateConnectionWithLagRequest(connectionId, lagId)
    def connectionId: ConnectionId
    def lagId: LagId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getLagId: ZIO[Any, Nothing, LagId] = ZIO.succeed(lagId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest
  ) extends zio.aws.directconnect.model.AssociateConnectionWithLagRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val lagId: LagId =
      zio.aws.directconnect.model.primitives.LagId(impl.lagId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest
  ): zio.aws.directconnect.model.AssociateConnectionWithLagRequest.ReadOnly =
    new Wrapper(impl)
}
