package zio.aws.directconnect.model
import scala.jdk.CollectionConverters.*
sealed trait BGPStatus {
  def unwrap: software.amazon.awssdk.services.directconnect.model.BGPStatus
}
object BGPStatus {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.BGPStatus
  ): zio.aws.directconnect.model.BGPStatus = value match {
    case software.amazon.awssdk.services.directconnect.model.BGPStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.BGPStatus.UP =>
      val r = up
      r
    case software.amazon.awssdk.services.directconnect.model.BGPStatus.DOWN =>
      val r = down
      r
    case software.amazon.awssdk.services.directconnect.model.BGPStatus.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.BGPStatus {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPStatus =
      software.amazon.awssdk.services.directconnect.model.BGPStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object up extends zio.aws.directconnect.model.BGPStatus {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPStatus =
      software.amazon.awssdk.services.directconnect.model.BGPStatus.UP
  }
  case object down extends zio.aws.directconnect.model.BGPStatus {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPStatus =
      software.amazon.awssdk.services.directconnect.model.BGPStatus.DOWN
  }
  case object unknown extends zio.aws.directconnect.model.BGPStatus {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.BGPStatus =
      software.amazon.awssdk.services.directconnect.model.BGPStatus.UNKNOWN
  }
}
