package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class ConfirmConnectionRequest(connectionId: ConnectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest = {
    import ConfirmConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmConnectionRequest.ReadOnly =
    zio.aws.directconnect.model.ConfirmConnectionRequest.wrap(buildAwsValue())
}
object ConfirmConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.ConfirmConnectionRequest =
      zio.aws.directconnect.model.ConfirmConnectionRequest(connectionId)
    def connectionId: ConnectionId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest
  ) extends zio.aws.directconnect.model.ConfirmConnectionRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest
  ): zio.aws.directconnect.model.ConfirmConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
