package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfirmConnectionResponse(
    connectionState: Optional[zio.aws.directconnect.model.ConnectionState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse = {
    import ConfirmConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse
      .builder()
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmConnectionResponse.ReadOnly =
    zio.aws.directconnect.model.ConfirmConnectionResponse.wrap(buildAwsValue())
}
object ConfirmConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.ConfirmConnectionResponse =
      zio.aws.directconnect.model
        .ConfirmConnectionResponse(connectionState.map(value => value))
    def connectionState: Optional[zio.aws.directconnect.model.ConnectionState]
    def getConnectionState
        : ZIO[Any, AwsError, zio.aws.directconnect.model.ConnectionState] =
      AwsError.unwrapOptionField("connectionState", connectionState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse
  ) extends zio.aws.directconnect.model.ConfirmConnectionResponse.ReadOnly {
    override val connectionState
        : Optional[zio.aws.directconnect.model.ConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionState())
        .map(value => zio.aws.directconnect.model.ConnectionState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse
  ): zio.aws.directconnect.model.ConfirmConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
