package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class CreatePublicVirtualInterfaceRequest(
    connectionId: ConnectionId,
    newPublicVirtualInterface: zio.aws.directconnect.model.NewPublicVirtualInterface
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest = {
    import CreatePublicVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .newPublicVirtualInterface(newPublicVirtualInterface.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.CreatePublicVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.CreatePublicVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object CreatePublicVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.CreatePublicVirtualInterfaceRequest =
      zio.aws.directconnect.model.CreatePublicVirtualInterfaceRequest(
        connectionId,
        newPublicVirtualInterface.asEditable
      )
    def connectionId: ConnectionId
    def newPublicVirtualInterface
        : zio.aws.directconnect.model.NewPublicVirtualInterface.ReadOnly
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getNewPublicVirtualInterface: ZIO[
      Any,
      Nothing,
      zio.aws.directconnect.model.NewPublicVirtualInterface.ReadOnly
    ] = ZIO.succeed(newPublicVirtualInterface)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.CreatePublicVirtualInterfaceRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val newPublicVirtualInterface
        : zio.aws.directconnect.model.NewPublicVirtualInterface.ReadOnly =
      zio.aws.directconnect.model.NewPublicVirtualInterface
        .wrap(impl.newPublicVirtualInterface())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest
  ): zio.aws.directconnect.model.CreatePublicVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
