package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  BGPPeerId,
  CustomerAddress,
  ASN,
  VirtualInterfaceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DeleteBgpPeerRequest(
    virtualInterfaceId: Optional[VirtualInterfaceId] = Optional.Absent,
    asn: Optional[ASN] = Optional.Absent,
    customerAddress: Optional[CustomerAddress] = Optional.Absent,
    bgpPeerId: Optional[BGPPeerId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest = {
    import DeleteBgpPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest
      .builder()
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(asn.map(value => ASN.unwrap(value): Integer))(_.asn)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .optionallyWith(
        bgpPeerId.map(value => BGPPeerId.unwrap(value): java.lang.String)
      )(_.bgpPeerId)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DeleteBgpPeerRequest.ReadOnly =
    zio.aws.directconnect.model.DeleteBgpPeerRequest.wrap(buildAwsValue())
}
object DeleteBgpPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DeleteBgpPeerRequest =
      zio.aws.directconnect.model.DeleteBgpPeerRequest(
        virtualInterfaceId.map(value => value),
        asn.map(value => value),
        customerAddress.map(value => value),
        bgpPeerId.map(value => value)
      )
    def virtualInterfaceId: Optional[VirtualInterfaceId]
    def asn: Optional[ASN]
    def customerAddress: Optional[CustomerAddress]
    def bgpPeerId: Optional[BGPPeerId]
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getAsn: ZIO[Any, AwsError, ASN] = AwsError.unwrapOptionField("asn", asn)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
    def getBgpPeerId: ZIO[Any, AwsError, BGPPeerId] =
      AwsError.unwrapOptionField("bgpPeerId", bgpPeerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest
  ) extends zio.aws.directconnect.model.DeleteBgpPeerRequest.ReadOnly {
    override val virtualInterfaceId: Optional[VirtualInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
        )
    override val asn: Optional[ASN] = zio.aws.core.internal
      .optionalFromNullable(impl.asn())
      .map(value => zio.aws.directconnect.model.primitives.ASN(value))
    override val customerAddress: Optional[CustomerAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerAddress())
        .map(value =>
          zio.aws.directconnect.model.primitives.CustomerAddress(value)
        )
    override val bgpPeerId: Optional[BGPPeerId] = zio.aws.core.internal
      .optionalFromNullable(impl.bgpPeerId())
      .map(value => zio.aws.directconnect.model.primitives.BGPPeerId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest
  ): zio.aws.directconnect.model.DeleteBgpPeerRequest.ReadOnly = new Wrapper(
    impl
  )
}
