package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class DeleteConnectionRequest(connectionId: ConnectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest = {
    import DeleteConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DeleteConnectionRequest.ReadOnly =
    zio.aws.directconnect.model.DeleteConnectionRequest.wrap(buildAwsValue())
}
object DeleteConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DeleteConnectionRequest =
      zio.aws.directconnect.model.DeleteConnectionRequest(connectionId)
    def connectionId: ConnectionId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest
  ) extends zio.aws.directconnect.model.DeleteConnectionRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest
  ): zio.aws.directconnect.model.DeleteConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
