package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.DirectConnectGatewayAssociationProposalId
import scala.jdk.CollectionConverters.*
final case class DeleteDirectConnectGatewayAssociationProposalRequest(
    proposalId: DirectConnectGatewayAssociationProposalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest = {
    import DeleteDirectConnectGatewayAssociationProposalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
      .builder()
      .proposalId(
        DirectConnectGatewayAssociationProposalId.unwrap(
          proposalId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest.ReadOnly =
    zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
      .wrap(buildAwsValue())
}
object DeleteDirectConnectGatewayAssociationProposalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest =
      zio.aws.directconnect.model
        .DeleteDirectConnectGatewayAssociationProposalRequest(proposalId)
    def proposalId: DirectConnectGatewayAssociationProposalId
    def getProposalId
        : ZIO[Any, Nothing, DirectConnectGatewayAssociationProposalId] =
      ZIO.succeed(proposalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
  ) extends zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest.ReadOnly {
    override val proposalId: DirectConnectGatewayAssociationProposalId =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayAssociationProposalId(impl.proposalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
  ): zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest.ReadOnly =
    new Wrapper(impl)
}
