package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDirectConnectGatewayAssociationResponse(
    directConnectGatewayAssociation: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse = {
    import DeleteDirectConnectGatewayAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse
      .builder()
      .optionallyWith(
        directConnectGatewayAssociation.map(value => value.buildAwsValue())
      )(_.directConnectGatewayAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.ReadOnly =
    zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse
      .wrap(buildAwsValue())
}
object DeleteDirectConnectGatewayAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse =
      zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse(
        directConnectGatewayAssociation.map(value => value.asEditable)
      )
    def directConnectGatewayAssociation: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly
    ]
    def getDirectConnectGatewayAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "directConnectGatewayAssociation",
      directConnectGatewayAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse
  ) extends zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.ReadOnly {
    override val directConnectGatewayAssociation: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.directConnectGatewayAssociation())
      .map(value =>
        zio.aws.directconnect.model.DirectConnectGatewayAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse
  ): zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
