package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.DirectConnectGatewayId
import scala.jdk.CollectionConverters.*
final case class DeleteDirectConnectGatewayRequest(
    directConnectGatewayId: DirectConnectGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest = {
    import DeleteDirectConnectGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest
      .builder()
      .directConnectGatewayId(
        DirectConnectGatewayId.unwrap(directConnectGatewayId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DeleteDirectConnectGatewayRequest.ReadOnly =
    zio.aws.directconnect.model.DeleteDirectConnectGatewayRequest
      .wrap(buildAwsValue())
}
object DeleteDirectConnectGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DeleteDirectConnectGatewayRequest =
      zio.aws.directconnect.model
        .DeleteDirectConnectGatewayRequest(directConnectGatewayId)
    def directConnectGatewayId: DirectConnectGatewayId
    def getDirectConnectGatewayId: ZIO[Any, Nothing, DirectConnectGatewayId] =
      ZIO.succeed(directConnectGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest
  ) extends zio.aws.directconnect.model.DeleteDirectConnectGatewayRequest.ReadOnly {
    override val directConnectGatewayId: DirectConnectGatewayId =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayId(impl.directConnectGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest
  ): zio.aws.directconnect.model.DeleteDirectConnectGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
