package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.LagId
import scala.jdk.CollectionConverters.*
final case class DeleteLagRequest(lagId: LagId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteLagRequest = {
    import DeleteLagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteLagRequest
      .builder()
      .lagId(LagId.unwrap(lagId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DeleteLagRequest.ReadOnly =
    zio.aws.directconnect.model.DeleteLagRequest.wrap(buildAwsValue())
}
object DeleteLagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteLagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DeleteLagRequest =
      zio.aws.directconnect.model.DeleteLagRequest(lagId)
    def lagId: LagId
    def getLagId: ZIO[Any, Nothing, LagId] = ZIO.succeed(lagId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteLagRequest
  ) extends zio.aws.directconnect.model.DeleteLagRequest.ReadOnly {
    override val lagId: LagId =
      zio.aws.directconnect.model.primitives.LagId(impl.lagId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteLagRequest
  ): zio.aws.directconnect.model.DeleteLagRequest.ReadOnly = new Wrapper(impl)
}
