package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.VirtualInterfaceId
import scala.jdk.CollectionConverters.*
final case class DeleteVirtualInterfaceRequest(
    virtualInterfaceId: VirtualInterfaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest = {
    import DeleteVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest
      .builder()
      .virtualInterfaceId(
        VirtualInterfaceId.unwrap(virtualInterfaceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DeleteVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.DeleteVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object DeleteVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DeleteVirtualInterfaceRequest =
      zio.aws.directconnect.model
        .DeleteVirtualInterfaceRequest(virtualInterfaceId)
    def virtualInterfaceId: VirtualInterfaceId
    def getVirtualInterfaceId: ZIO[Any, Nothing, VirtualInterfaceId] =
      ZIO.succeed(virtualInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.DeleteVirtualInterfaceRequest.ReadOnly {
    override val virtualInterfaceId: VirtualInterfaceId =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceId(impl.virtualInterfaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest
  ): zio.aws.directconnect.model.DeleteVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
