package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class DescribeDirectConnectGatewayAttachmentsResponse(
    directConnectGatewayAttachments: Optional[
      Iterable[zio.aws.directconnect.model.DirectConnectGatewayAttachment]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse = {
    import DescribeDirectConnectGatewayAttachmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
      .builder()
      .optionallyWith(
        directConnectGatewayAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.directConnectGatewayAttachments)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewayAttachmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse =
      zio.aws.directconnect.model
        .DescribeDirectConnectGatewayAttachmentsResponse(
          directConnectGatewayAttachments.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def directConnectGatewayAttachments: Optional[
      List[zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getDirectConnectGatewayAttachments: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "directConnectGatewayAttachments",
      directConnectGatewayAttachments
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly {
    override val directConnectGatewayAttachments: Optional[
      List[zio.aws.directconnect.model.DirectConnectGatewayAttachment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.directConnectGatewayAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.DirectConnectGatewayAttachment.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse.ReadOnly =
    new Wrapper(impl)
}
