package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class DescribeHostedConnectionsRequest(connectionId: ConnectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest = {
    import DescribeHostedConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeHostedConnectionsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeHostedConnectionsRequest
      .wrap(buildAwsValue())
}
object DescribeHostedConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeHostedConnectionsRequest =
      zio.aws.directconnect.model.DescribeHostedConnectionsRequest(connectionId)
    def connectionId: ConnectionId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest
  ) extends zio.aws.directconnect.model.DescribeHostedConnectionsRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest
  ): zio.aws.directconnect.model.DescribeHostedConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
