package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{ProviderName, ConnectionId}
import scala.jdk.CollectionConverters.*
final case class DescribeLoaRequest(
    connectionId: ConnectionId,
    providerName: Optional[ProviderName] = Optional.Absent,
    loaContentType: Optional[zio.aws.directconnect.model.LoaContentType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest = {
    import DescribeLoaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .optionallyWith(loaContentType.map(value => value.unwrap))(
        _.loaContentType
      )
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DescribeLoaRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeLoaRequest.wrap(buildAwsValue())
}
object DescribeLoaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeLoaRequest =
      zio.aws.directconnect.model.DescribeLoaRequest(
        connectionId,
        providerName.map(value => value),
        loaContentType.map(value => value)
      )
    def connectionId: ConnectionId
    def providerName: Optional[ProviderName]
    def loaContentType: Optional[zio.aws.directconnect.model.LoaContentType]
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getLoaContentType
        : ZIO[Any, AwsError, zio.aws.directconnect.model.LoaContentType] =
      AwsError.unwrapOptionField("loaContentType", loaContentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest
  ) extends zio.aws.directconnect.model.DescribeLoaRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val providerName: Optional[ProviderName] = zio.aws.core.internal
      .optionalFromNullable(impl.providerName())
      .map(value => zio.aws.directconnect.model.primitives.ProviderName(value))
    override val loaContentType
        : Optional[zio.aws.directconnect.model.LoaContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loaContentType())
        .map(value => zio.aws.directconnect.model.LoaContentType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest
  ): zio.aws.directconnect.model.DescribeLoaRequest.ReadOnly = new Wrapper(impl)
}
