package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  RouterTypeIdentifier,
  VirtualInterfaceId
}
import scala.jdk.CollectionConverters.*
final case class DescribeRouterConfigurationRequest(
    virtualInterfaceId: VirtualInterfaceId,
    routerTypeIdentifier: Optional[RouterTypeIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationRequest = {
    import DescribeRouterConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationRequest
      .builder()
      .virtualInterfaceId(
        VirtualInterfaceId.unwrap(virtualInterfaceId): java.lang.String
      )
      .optionallyWith(
        routerTypeIdentifier.map(value =>
          RouterTypeIdentifier.unwrap(value): java.lang.String
        )
      )(_.routerTypeIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeRouterConfigurationRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeRouterConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeRouterConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeRouterConfigurationRequest =
      zio.aws.directconnect.model.DescribeRouterConfigurationRequest(
        virtualInterfaceId,
        routerTypeIdentifier.map(value => value)
      )
    def virtualInterfaceId: VirtualInterfaceId
    def routerTypeIdentifier: Optional[RouterTypeIdentifier]
    def getVirtualInterfaceId: ZIO[Any, Nothing, VirtualInterfaceId] =
      ZIO.succeed(virtualInterfaceId)
    def getRouterTypeIdentifier: ZIO[Any, AwsError, RouterTypeIdentifier] =
      AwsError.unwrapOptionField("routerTypeIdentifier", routerTypeIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationRequest
  ) extends zio.aws.directconnect.model.DescribeRouterConfigurationRequest.ReadOnly {
    override val virtualInterfaceId: VirtualInterfaceId =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceId(impl.virtualInterfaceId())
    override val routerTypeIdentifier: Optional[RouterTypeIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routerTypeIdentifier())
        .map(value =>
          zio.aws.directconnect.model.primitives.RouterTypeIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationRequest
  ): zio.aws.directconnect.model.DescribeRouterConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
