package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  VirtualInterfaceName,
  VirtualInterfaceId,
  RouterConfig
}
import scala.jdk.CollectionConverters.*
final case class DescribeRouterConfigurationResponse(
    customerRouterConfig: Optional[RouterConfig] = Optional.Absent,
    router: Optional[zio.aws.directconnect.model.RouterType] = Optional.Absent,
    virtualInterfaceId: Optional[VirtualInterfaceId] = Optional.Absent,
    virtualInterfaceName: Optional[VirtualInterfaceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationResponse = {
    import DescribeRouterConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationResponse
      .builder()
      .optionallyWith(
        customerRouterConfig.map(value =>
          RouterConfig.unwrap(value): java.lang.String
        )
      )(_.customerRouterConfig)
      .optionallyWith(router.map(value => value.buildAwsValue()))(_.router)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(
        virtualInterfaceName.map(value =>
          VirtualInterfaceName.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceName)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeRouterConfigurationResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeRouterConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeRouterConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeRouterConfigurationResponse =
      zio.aws.directconnect.model.DescribeRouterConfigurationResponse(
        customerRouterConfig.map(value => value),
        router.map(value => value.asEditable),
        virtualInterfaceId.map(value => value),
        virtualInterfaceName.map(value => value)
      )
    def customerRouterConfig: Optional[RouterConfig]
    def router: Optional[zio.aws.directconnect.model.RouterType.ReadOnly]
    def virtualInterfaceId: Optional[VirtualInterfaceId]
    def virtualInterfaceName: Optional[VirtualInterfaceName]
    def getCustomerRouterConfig: ZIO[Any, AwsError, RouterConfig] =
      AwsError.unwrapOptionField("customerRouterConfig", customerRouterConfig)
    def getRouter
        : ZIO[Any, AwsError, zio.aws.directconnect.model.RouterType.ReadOnly] =
      AwsError.unwrapOptionField("router", router)
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getVirtualInterfaceName: ZIO[Any, AwsError, VirtualInterfaceName] =
      AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationResponse
  ) extends zio.aws.directconnect.model.DescribeRouterConfigurationResponse.ReadOnly {
    override val customerRouterConfig: Optional[RouterConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerRouterConfig())
        .map(value =>
          zio.aws.directconnect.model.primitives.RouterConfig(value)
        )
    override val router
        : Optional[zio.aws.directconnect.model.RouterType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.router())
        .map(value => zio.aws.directconnect.model.RouterType.wrap(value))
    override val virtualInterfaceId: Optional[VirtualInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
        )
    override val virtualInterfaceName: Optional[VirtualInterfaceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceName())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationResponse
  ): zio.aws.directconnect.model.DescribeRouterConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
