package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class DescribeTagsRequest(resourceArns: Iterable[ResourceArn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest = {
    import DescribeTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest
      .builder()
      .resourceArns(resourceArns.map { item =>
        ResourceArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DescribeTagsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeTagsRequest.wrap(buildAwsValue())
}
object DescribeTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeTagsRequest =
      zio.aws.directconnect.model.DescribeTagsRequest(resourceArns)
    def resourceArns: List[ResourceArn]
    def getResourceArns: ZIO[Any, Nothing, List[ResourceArn]] =
      ZIO.succeed(resourceArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest
  ) extends zio.aws.directconnect.model.DescribeTagsRequest.ReadOnly {
    override val resourceArns: List[ResourceArn] = impl
      .resourceArns()
      .asScala
      .map { item =>
        zio.aws.directconnect.model.primitives.ResourceArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest
  ): zio.aws.directconnect.model.DescribeTagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
