package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.{LagId, ConnectionId}
import scala.jdk.CollectionConverters.*
final case class DisassociateConnectionFromLagRequest(
    connectionId: ConnectionId,
    lagId: LagId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest = {
    import DisassociateConnectionFromLagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .lagId(LagId.unwrap(lagId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DisassociateConnectionFromLagRequest.ReadOnly =
    zio.aws.directconnect.model.DisassociateConnectionFromLagRequest
      .wrap(buildAwsValue())
}
object DisassociateConnectionFromLagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DisassociateConnectionFromLagRequest =
      zio.aws.directconnect.model
        .DisassociateConnectionFromLagRequest(connectionId, lagId)
    def connectionId: ConnectionId
    def lagId: LagId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getLagId: ZIO[Any, Nothing, LagId] = ZIO.succeed(lagId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest
  ) extends zio.aws.directconnect.model.DisassociateConnectionFromLagRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val lagId: LagId =
      zio.aws.directconnect.model.primitives.LagId(impl.lagId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest
  ): zio.aws.directconnect.model.DisassociateConnectionFromLagRequest.ReadOnly =
    new Wrapper(impl)
}
