package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  CustomerAddress,
  AmazonAddress,
  BGPAuthKey,
  ASN
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class NewBGPPeer(
    asn: Optional[ASN] = Optional.Absent,
    authKey: Optional[BGPAuthKey] = Optional.Absent,
    addressFamily: Optional[zio.aws.directconnect.model.AddressFamily] =
      Optional.Absent,
    amazonAddress: Optional[AmazonAddress] = Optional.Absent,
    customerAddress: Optional[CustomerAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.NewBGPPeer = {
    import NewBGPPeer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.NewBGPPeer
      .builder()
      .optionallyWith(asn.map(value => ASN.unwrap(value): Integer))(_.asn)
      .optionallyWith(
        authKey.map(value => BGPAuthKey.unwrap(value): java.lang.String)
      )(_.authKey)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(
        amazonAddress.map(value =>
          AmazonAddress.unwrap(value): java.lang.String
        )
      )(_.amazonAddress)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.NewBGPPeer.ReadOnly =
    zio.aws.directconnect.model.NewBGPPeer.wrap(buildAwsValue())
}
object NewBGPPeer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.NewBGPPeer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.NewBGPPeer =
      zio.aws.directconnect.model.NewBGPPeer(
        asn.map(value => value),
        authKey.map(value => value),
        addressFamily.map(value => value),
        amazonAddress.map(value => value),
        customerAddress.map(value => value)
      )
    def asn: Optional[ASN]
    def authKey: Optional[BGPAuthKey]
    def addressFamily: Optional[zio.aws.directconnect.model.AddressFamily]
    def amazonAddress: Optional[AmazonAddress]
    def customerAddress: Optional[CustomerAddress]
    def getAsn: ZIO[Any, AwsError, ASN] = AwsError.unwrapOptionField("asn", asn)
    def getAuthKey: ZIO[Any, AwsError, BGPAuthKey] =
      AwsError.unwrapOptionField("authKey", authKey)
    def getAddressFamily
        : ZIO[Any, AwsError, zio.aws.directconnect.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getAmazonAddress: ZIO[Any, AwsError, AmazonAddress] =
      AwsError.unwrapOptionField("amazonAddress", amazonAddress)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.NewBGPPeer
  ) extends zio.aws.directconnect.model.NewBGPPeer.ReadOnly {
    override val asn: Optional[ASN] = zio.aws.core.internal
      .optionalFromNullable(impl.asn())
      .map(value => zio.aws.directconnect.model.primitives.ASN(value))
    override val authKey: Optional[BGPAuthKey] = zio.aws.core.internal
      .optionalFromNullable(impl.authKey())
      .map(value => zio.aws.directconnect.model.primitives.BGPAuthKey(value))
    override val addressFamily
        : Optional[zio.aws.directconnect.model.AddressFamily] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressFamily())
        .map(value => zio.aws.directconnect.model.AddressFamily.wrap(value))
    override val amazonAddress: Optional[AmazonAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonAddress())
      .map(value => zio.aws.directconnect.model.primitives.AmazonAddress(value))
    override val customerAddress: Optional[CustomerAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerAddress())
        .map(value =>
          zio.aws.directconnect.model.primitives.CustomerAddress(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.NewBGPPeer
  ): zio.aws.directconnect.model.NewBGPPeer.ReadOnly = new Wrapper(impl)
}
