package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  RouterTypeIdentifier,
  Vendor,
  XsltTemplateNameForMacSec,
  Platform,
  Software,
  XsltTemplateName
}
import scala.jdk.CollectionConverters.*
final case class RouterType(
    vendor: Optional[Vendor] = Optional.Absent,
    platform: Optional[Platform] = Optional.Absent,
    software: Optional[Software] = Optional.Absent,
    xsltTemplateName: Optional[XsltTemplateName] = Optional.Absent,
    xsltTemplateNameForMacSec: Optional[XsltTemplateNameForMacSec] =
      Optional.Absent,
    routerTypeIdentifier: Optional[RouterTypeIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : _root_.software.amazon.awssdk.services.directconnect.model.RouterType = {
    import RouterType.zioAwsBuilderHelper.BuilderOps
    _root_.software.amazon.awssdk.services.directconnect.model.RouterType
      .builder()
      .optionallyWith(
        vendor.map(value => Vendor.unwrap(value): java.lang.String)
      )(_.vendor)
      .optionallyWith(
        platform.map(value => Platform.unwrap(value): java.lang.String)
      )(_.platform)
      .optionallyWith(
        software.map(value => Software.unwrap(value): java.lang.String)
      )(_.software)
      .optionallyWith(
        xsltTemplateName.map(value =>
          XsltTemplateName.unwrap(value): java.lang.String
        )
      )(_.xsltTemplateName)
      .optionallyWith(
        xsltTemplateNameForMacSec.map(value =>
          XsltTemplateNameForMacSec.unwrap(value): java.lang.String
        )
      )(_.xsltTemplateNameForMacSec)
      .optionallyWith(
        routerTypeIdentifier.map(value =>
          RouterTypeIdentifier.unwrap(value): java.lang.String
        )
      )(_.routerTypeIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.RouterType.ReadOnly =
    zio.aws.directconnect.model.RouterType.wrap(buildAwsValue())
}
object RouterType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    _root_.software.amazon.awssdk.services.directconnect.model.RouterType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.RouterType =
      zio.aws.directconnect.model.RouterType(
        vendor.map(value => value),
        platform.map(value => value),
        software.map(value => value),
        xsltTemplateName.map(value => value),
        xsltTemplateNameForMacSec.map(value => value),
        routerTypeIdentifier.map(value => value)
      )
    def vendor: Optional[Vendor]
    def platform: Optional[Platform]
    def software: Optional[Software]
    def xsltTemplateName: Optional[XsltTemplateName]
    def xsltTemplateNameForMacSec: Optional[XsltTemplateNameForMacSec]
    def routerTypeIdentifier: Optional[RouterTypeIdentifier]
    def getVendor: ZIO[Any, AwsError, Vendor] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getPlatform: ZIO[Any, AwsError, Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSoftware: ZIO[Any, AwsError, Software] =
      AwsError.unwrapOptionField("software", software)
    def getXsltTemplateName: ZIO[Any, AwsError, XsltTemplateName] =
      AwsError.unwrapOptionField("xsltTemplateName", xsltTemplateName)
    def getXsltTemplateNameForMacSec
        : ZIO[Any, AwsError, XsltTemplateNameForMacSec] = AwsError
      .unwrapOptionField("xsltTemplateNameForMacSec", xsltTemplateNameForMacSec)
    def getRouterTypeIdentifier: ZIO[Any, AwsError, RouterTypeIdentifier] =
      AwsError.unwrapOptionField("routerTypeIdentifier", routerTypeIdentifier)
  }
  private final class Wrapper(
      impl: _root_.software.amazon.awssdk.services.directconnect.model.RouterType
  ) extends zio.aws.directconnect.model.RouterType.ReadOnly {
    override val vendor: Optional[Vendor] = zio.aws.core.internal
      .optionalFromNullable(impl.vendor())
      .map(value => zio.aws.directconnect.model.primitives.Vendor(value))
    override val platform: Optional[Platform] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => zio.aws.directconnect.model.primitives.Platform(value))
    override val software: Optional[Software] = zio.aws.core.internal
      .optionalFromNullable(impl.software())
      .map(value => zio.aws.directconnect.model.primitives.Software(value))
    override val xsltTemplateName: Optional[XsltTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xsltTemplateName())
        .map(value =>
          zio.aws.directconnect.model.primitives.XsltTemplateName(value)
        )
    override val xsltTemplateNameForMacSec
        : Optional[XsltTemplateNameForMacSec] = zio.aws.core.internal
      .optionalFromNullable(impl.xsltTemplateNameForMacSec())
      .map(value =>
        zio.aws.directconnect.model.primitives.XsltTemplateNameForMacSec(value)
      )
    override val routerTypeIdentifier: Optional[RouterTypeIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routerTypeIdentifier())
        .map(value =>
          zio.aws.directconnect.model.primitives.RouterTypeIdentifier(value)
        )
  }
  def wrap(
      impl: _root_.software.amazon.awssdk.services.directconnect.model.RouterType
  ): zio.aws.directconnect.model.RouterType.ReadOnly = new Wrapper(impl)
}
