package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDirectConnectGatewayResponse(
    directConnectGateway: Optional[
      zio.aws.directconnect.model.DirectConnectGateway
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayResponse = {
    import UpdateDirectConnectGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayResponse
      .builder()
      .optionallyWith(directConnectGateway.map(value => value.buildAwsValue()))(
        _.directConnectGateway
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse.ReadOnly =
    zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse
      .wrap(buildAwsValue())
}
object UpdateDirectConnectGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse =
      zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse(
        directConnectGateway.map(value => value.asEditable)
      )
    def directConnectGateway
        : Optional[zio.aws.directconnect.model.DirectConnectGateway.ReadOnly]
    def getDirectConnectGateway: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGateway.ReadOnly
    ] = AwsError.unwrapOptionField("directConnectGateway", directConnectGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayResponse
  ) extends zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse.ReadOnly {
    override val directConnectGateway
        : Optional[zio.aws.directconnect.model.DirectConnectGateway.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGateway())
        .map(value =>
          zio.aws.directconnect.model.DirectConnectGateway.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayResponse
  ): zio.aws.directconnect.model.UpdateDirectConnectGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
